/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "CoreMinimal.h"
#include "Components/HierarchicalInstancedStaticMeshComponent.h"
#include <Components/SplineComponent.h>
#include "TrackPos.generated.h"

/// <summary>
/// The <c>UTrackPos</c> class represents a section of track on the tank.
/// It contains the spline component it is part of, the static mesh to use
/// for this component, its distance to the next point, and its current length.
/// 
/// For more info, see <c>APhysicsTankPawn::UpdateTrackInstances()</c>
/// </summary>
UCLASS(config = Game)
class UTrackPos : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// An id number used to reference this track piece in the spline.
	/// </summary>
	int myInstance;

	/// <summary>
	/// The length of the spline from the starting point to this 
	/// track piece.
	/// </summary>
	float myCDist;

	/// <summary>
	/// The static mesh component used for the visual representation
	/// of this track piece.
	/// </summary>
	UHierarchicalInstancedStaticMeshComponent* myHISMC;

	/// <summary>
	/// The root spline containing this track piece and the other pieces.
	/// </summary>
	USplineComponent* mySpline;

	/// <summary>
	/// The length of this current track piece in the spline. 
	/// The length can change depending on the speed of the tank
	/// and its obstacles. 
	/// </summary>
	float myCurrentSplineLength;

	/// <summary>
	/// Default constructor.
	/// </summary>
	UTrackPos();
};
