/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once

#include "CoreMinimal.h"
#include <Components/SplineComponent.h>
#include <Components/ArrowComponent.h>
#include "TrackPoint.generated.h"

/// <summary>
/// A single track point on the spline that makes up the track. 
/// See the blueprint side for more details.
/// </summary>
UCLASS(config = Game)
class UTrackPoint : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// An index for this point in the spline.
	/// </summary>
	int mySplinePoint;

	/// <summary>
	/// An arrow used for showing the direction this is facing.
	/// </summary>
	UArrowComponent* myTrackArrow;

	/// <summary>
	/// The corresponding wheel on the track.
	/// </summary>
	UStaticMeshComponent* myAssignedWheel;

	/// <summary>
	/// Default Constructor.
	/// </summary>
	UTrackPoint();

	/// <summary>
	/// Parameterized constructor.
	/// </summary>
	/// <param name="splinePoint">The index for the point on the spline.</param>
	/// <param name="trackArrow">An arrow used for showing the direction this is facing.</param>
	/// <param name="assignedWheel">The corresponding wheel on the track.</param>
	UTrackPoint(const int splinePoint, UArrowComponent* trackArrow, UStaticMeshComponent* assignedWheel);
};
