/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#include "TrackPoint.h"

/// <summary>
/// Default Constructor.
/// </summary>
UTrackPoint::UTrackPoint()
{

}

/// <summary>
/// Parameterized constructor.
/// </summary>
/// <param name="splinePoint">The index for the point on the spline.</param>
/// <param name="trackArrow">An arrow used for showing the direction this is facing.</param>
/// <param name="assignedWheel">The corresponding wheel on the track.</param>
UTrackPoint::UTrackPoint(const int splinePoint, UArrowComponent* trackArrow, UStaticMeshComponent* assignedWheel)
{
	mySplinePoint = splinePoint;
	myTrackArrow = trackArrow;
	myAssignedWheel = assignedWheel;
}