/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "NeuralTanksUtils.generated.h"

/// <summary>
/// This class holds utility functions that are generic and don't
/// have a particular class associated with it (for example, writing output
/// to a log).
/// </summary>
UCLASS()
class UNeuralTanksUtils : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// Prints/Writes a specified string to the developer console. This
	/// is typically used for debugging and is disabled during shipping
	/// builds of the game. In other words, nothing is printed/written
	/// for shipping builds.
	/// </summary>
	/// <param name="message">The message to print/write to the developer console.</param>
	static void WriteToLog(const FString& message);
};