/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "../NeuralTanksGameInstance.h"
#include <MoviePlayer.h>
#include <Widgets/SCompoundWidget.h>
#include <Modules/ModuleManager.h>
#include <Widgets/DeclarativeSyntaxSupport.h>
#include <Widgets/SBoxPanel.h>
#include <Widgets/Text/STextBlock.h>
#include <Widgets/Images/SThrobber.h>
#include <Engine/Font.h>
#include <Engine/World.h>
#include <Kismet/GameplayStatics.h>

/// <summary>
/// The SLATE UI used for the loading screens. This includes a loading bar,
/// a localized loading message (such as Now Loading...) and a randomly selected
/// Localized tip/hint for the player.
/// </summary>
class SNeuralTanksLoadingScreen : public SCompoundWidget
{
public:
	/// <summary>
	/// Declare a SLATE UI and specify that we are going to use an FText
	/// argument, this is for passing the localized loading screen tip.
	/// </summary>
	/// <param name=""></param>
	SLATE_BEGIN_ARGS(SNeuralTanksLoadingScreen) {}
	SLATE_ATTRIBUTE(FText, LoadingScreenTip)
	SLATE_END_ARGS()

	/// <summary>
	/// Called when this SLATE UI is first built.
	/// </summary>
	/// <param name="InArgs">The additional arguments (in our case, the LoadingScreenTip).</param>
	void Construct(const FArguments& InArgs);

protected:

	/// <summary>
	/// The randomly selected localized loading screen tip to show.
	/// </summary>
	FText myLoadingScreenTip;

	/// <summary>
	/// Returns true if the loading indicator should be visible, false otherwise.
	/// This is dependent on if loading is finished or not.
	/// </summary>
	/// <returns>true if the loading indicator should be visible, false otherwise.</returns>
	EVisibility GetLoadIndicatorVisibility() const;

	/// <summary>
	/// Returns true if the message indicator should be visible, false otherwise.
	/// This is dependent on if loading is finished or not.
	/// </summary>
	/// <returns>true if the message indicator should be visible, false otherwise.</returns>
	EVisibility GetMessageIndicatorVisibility() const;

	/// <summary>
	/// Returns true if the localized tip should be visible, false otherwise.
	/// This is dependent on if loading is finished or not.
	/// </summary>
	/// <returns>true if the localized tip should be visible, false otherwise.</returns>
	EVisibility GetTipsVisibility() const;
};