/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "SaveFileMetaData.generated.h"

/// <summary>
/// This class is responsible for storing and saving "metadata" for the game.
/// This contains the total number of saves the player has made, and a list
/// of the corresponding save file names and their dates.
/// </summary>
UCLASS()
class USaveFileMetaData : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// The total number of save files available to load.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int ToalNumberOfSaveFiles = 0;

	/// <summary>
	/// The list containing all the save file names and their corresponding dates.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	TMap<FName, FDateTime> SaveFileNamesAndDates;

	/// <summary>
	/// The serialized data array for the above data.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	TArray<uint8> ByteData;
};