/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "OptionsData.generated.h"

/// <summary>
/// This class is responsible for saving and containing the player/user settings
/// in the options menu(s). 
/// </summary>
UCLASS()
class UOptionsData : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// The volume level for all volumes.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	float MasterVolume = 100.0;

	/// <summary>
	/// The volume level for music from the boombox/radio.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	float MusicVolume = 100.0;

	/// <summary>
	/// The volume level for sound effects.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	float SFXVolume = 100.0;

	/// <summary>
	/// The volume level for voice over lines.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	float VoiceVolume = 100.0;

	/// <summary>
	/// The Anti Aliasing Quality for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int AntiAliasingQuality = 4;

	/// <summary>
	/// The overall particle effect quality for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int EffectsQuality = 4;

	/// <summary>
	/// The post processing quality for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int PostProcessQuality = 4;
	
	/// <summary>
	/// The shadow detail/quality for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int ShadowQuality = 4;

	/// <summary>
	/// The texture resolution detail/quality for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int TextureQuality = 4;

	/// <summary>
	/// The rendered view distance for the video settings (1 to 4).
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite, SaveGame)
	int ViewDistanceQuality = 4;

	/// <summary>
	/// The above options data in a seralizeable byte array.
	/// </summary>
	UPROPERTY(EditAnywhere, BlueprintReadWrite)
	TArray<uint8> ByteData;
};