/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "Pawns/PlayerTankPawn.h"
#include "Engine/Canvas.h"
#include "Engine/Texture2D.h"
#include "GameFramework/HUD.h"
#include <Components/WidgetComponent.h>
#include "NeuralTanksHud.generated.h"

/// <summary>
/// Generic parent class for the Neural Tanks HUD.
/// </summary>
UCLASS(config = Game)
class ANeuralTanksHud : public AHUD
{
	GENERATED_BODY()
public:
	/// <summary>
	/// Default Constructor.
	/// </summary>
	ANeuralTanksHud();

	/// <summary>
	/// Called in the main draw loop for the UI. Gets called before any messaging. 
	/// </summary>
	virtual void DrawHUD() override;
};
