/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#include "NeuralTanksCheatManager.h"

/// <summary>
/// Default constructor.
/// </summary>
UNeuralTanksCheatManager::UNeuralTanksCheatManager()
{
	myCheats.Add(ECheatName::VE_GODMODE, false);
	myCheats.Add(ECheatName::VE_ALLGOLDARMOR, false);
	myCheats.Add(ECheatName::VE_ALLLEVELSUNLOCKED, false);
	myCheats.Add(ECheatName::VE_INSTANTRELOAD, false);
	myCheats.Add(ECheatName::VE_HASMAXCASH, false);
}

/// <summary>
/// Returns true if the provided cheat is enabled, false if it is disabled.
/// </summary>
/// <param name="cheatName">The cheat to check.</param>
/// <returns>true if the provided cheat is enabled, false if it is disabled.</returns>
bool UNeuralTanksCheatManager::IsCheatEnabled(const ECheatName cheatName)
{
	return myCheats[cheatName];
}

/// <summary>
/// Enables/disables a provided cheat for the player. 
/// </summary>
/// <param name="cheatName">The cheat to enable or disable.</param>
/// <param name="isEnabled">true to enable the cheat, false to disable it.</param>
void UNeuralTanksCheatManager::ToggleCheat(const ECheatName cheatName, const bool isEnabled)
{
	if (OnCheatToggled_Event.IsBound() == true)
	{
		OnCheatToggled_Event.Broadcast(cheatName, isEnabled);
	}

	myCheats[cheatName] = isEnabled;
}