/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#pragma once
#include "AchievementManager.generated.h"

//Achievement_0_Id = "TWIN_PEAKS_ACHIEVEMENT_1_0"
//Achievement_1_Id = "THE_KINTAMA_TWINS_ACHIEVEMENT_1_1"
//Achievement_2_Id = "GREAT_SUCCESS_ACHIEVEMENT_1_2"
//Achievement_3_Id = "SOLID_GOLD_ACHIEVEMENT_1_3"
//Achievement_4_Id = "COMPLETIONIST_ACHIEVEMENT_1_4"

/// <summary>
/// Represents a particular achivement that the player can unlock. 
/// </summary>
UENUM(BlueprintType)
enum class ENeuralTanksAchievement : uint8
{
	TWIN_PEAKS_ACHIEVEMENT_1_0 			UMETA(DisplayName = "Twin Peaks - Unlock all the tank boobs."),
	THE_KINTAMA_TWINS_ACHIEVEMENT_1_1	UMETA(DisplayName = "The Kintama Twins - Unlock golden tank nuts."),
	GREAT_SUCCESS_ACHIEVEMENT_1_2		UMETA(DisplayName = "Great Success - Beat the game."),
	SOLID_GOLD_ACHIEVEMENT_1_3			UMETA(DisplayName = "Solid Gold - Unlock all gold armor."),
	COMPLETIONIST_ACHIEVEMENT_1_4		UMETA(DisplayName = "Completionist - Unlock every item.")
};

UCLASS()
/// <summary>
/// Responsible for managing all the achievements and rewarding specific achievement(s) to the player.
/// </summary>
class UAchievementManager : public UObject
{
	GENERATED_BODY()

public:
	/// <summary>
	/// Reward the specified achievement to the player using the available online subsystem.
	/// </summary>
	/// <param name="theAchievement">The specific achievement to reward the player.</param>
	static void RewardAchievement(const ENeuralTanksAchievement& theAchievement);

	/// <summary>
	/// The Achievements Interface needs to be queried before writing can begin.
	/// </summary>
	static void QueryAchievements();
};