/*
* Neural Tanks is a game created by Eddie O'Hagan that leverages Neural Networking
* to use for AI. This was created in Unreal Engine 4 which is developed by Epic Games.
* (Copyright Epic Games, Inc. All Rights Reserved.)
*
* Smart Tanks was originally developed by Mat Buckland in 2002 as an example
* on how Neural Networking can be used to train a set of minesweepers
* to collect mines. I (Eddie O'Hagan) updated this project in 2024 to use more
* Object Oriented Programming and modern practices. To see the original tutorial;
* visit <see href="http://www.ai-junkie.com/ann/evolved/nnt1.html">Neural Networking Tutorial</see>
* and <see href="http://www.ai-junkie.com/ga/intro/gat1.html">Genetic Algorithm Tutorial</see>
*/
#include "BTTask_ProcessNeuralNetwork.h"
#include "../Pawns/AITankPawn.h"
#include "../NeuralTanksGameMode.h"
#include "../Controllers/NeuralTanksAIController.h"

/// <summary>
/// Called when this task is first activated in the behavior tree (basically a constructor).
/// </summary>
/// <param name="task">A reference to the owning task.</param>
void UBTTask_ProcessNeuralNetwork::OnGameplayTaskActivated(UGameplayTask& task)
{

}

/// <summary>
/// Called by the behavior tree to process the Neural Network for this AI. This effectively
/// has the Neural Network controlling/driving the tank. 
/// 
/// This comment is from the parent function: "starts this task, should return Succeeded, Failed 
/// or InProgress (use FinishLatentTask() when returning InProgress) this function should be 
/// considered as const (don't modify state of object) if node is not instanced!"
/// </summary>
/// <param name="ownerComp">The owning behavior tree for this task.</param>
/// <param name="nodeMemory">Additional buffer of memory used by the node (unused by us).</param>
/// <returns>The current status of the task (Succeeded or Failed).</returns>
EBTNodeResult::Type UBTTask_ProcessNeuralNetwork::ExecuteTask(UBehaviorTreeComponent& ownerComp, uint8* nodeMemory)
{
	//I'm not crazy about having to do these casts repeatedly, but there is no avoiding it as far as I can see.
	ANeuralTanksAIController* aiController = Cast<ANeuralTanksAIController>(ownerComp.GetOwner());
	AAITankPawn* theAITankPawn = Cast<AAITankPawn>(aiController->GetPawn());

	if (theAITankPawn->ProcessNeuralNetwork() == true)
	{
		return EBTNodeResult::Type::Succeeded;
	}
	else
	{
		return EBTNodeResult::Type::Failed;
	}
}